#!/usr/bin/env python

import sys
import getopt
import os.path
import os

wroteToErrFile = False

def writeError( errorString, errFile ):
	globals()["wroteToErrFile"] = True
	errFile.write( "Error: " )
	errFile.write( errorString )
	errFile.write( '\n' )
	return

def writeWarning( warningString, errFile ):
	globals()["wroteToErrFile"] = True
	errFile.write( "Warning: " )
	errFile.write( warningString )
	errFile.write( '\n' )
	return

def verifyThemeXMLFile( themeFilename, errFile ):
	return True

def verifyPageXMLFiles( themeFilename, errFile ):
	return True

def verifyFile( themeFilename, errFile ):
	if not themeFilename:
		writeError( "Supplied empty theme filename", errFile )
		return False

	if themeFilename.startswith( '~' ):
		themeFilename = os.path.expanduser( themeFilename )

	# Check to see if the file exists and whether it is a folder

	if not os.path.exists( themeFilename ) and not os.path.isdir( themeFilename ):
		if not os.path.exists( themeFilename ):
			writeError( themeFilename+" does not exist", errFile )
		if not os.path.isdir( themeFilename ):
			writeError( themeFilename+" isn't a folder", errFile )
		return False

	# The folder should contain at least a Contents folder as well as an index.xml.gz or index.xml file

	contentsFolder = themeFilename+"/Contents"
	if not os.path.exists( contentsFolder ) and not os.path.isdir( contentsFolder ):
		if not os.path.exists( contentsFolder ):
			writeError( contentsFolder+" does not exist", errFile )
		if not os.path.isdir( contentsFolder ):
			writeError( contentsFolder+" isn't a folder", errFile )
		return False

	indexFile = themeFilename+"/index.xml"
	if not os.path.exists( indexFile+".gz" ) and not os.path.exists( indexFile ):
		if not os.path.exists( indexFile+".gz" ):
			writeError( themeFilename+" does not have a index.xml.gz file", errFile )
		if not os.path.exists( indexFile ):
			writeError( themeFilename+" does not have a index.xml file", errFile )
		return False

	# Open the theme XML file validate

	if verifyThemeXMLFile( themeFilename, errFile ):
		return False

	# Open the webtemplate files within the theme bundle and validate them

 	if verifyPageXMLFiles( themeFilename, errFile ):
		return False

	return True
	
def main( argv ):
	# Remove the result file before processing the supplied file.

	errorFileName = argv[1]
	if os.path.exists( errorFileName ):
		os.remove( errorFileName )

	errFile = open( errorFileName, 'w' )

	# Basic check to see if the file exists before processing

	fileName = argv[0]
	success = verifyFile( fileName, errFile )

	errFile.close()

	# Just remove the error file if we did not write anything in it.

	if not wroteToErrFile:
		os.remove( errorFileName )

	if success:
		return 1
	else:
		return 0

if __name__ == "__main__":
	main( sys.argv[1:] )
