//
//  iWeb - iWAnimation.js
//  Copyright (c) 2006-2008 Apple Inc. All rights reserved.
//

//  Responsibility: mmurrett
//  Reviewers: mmurrett, krevis, ksmyth
//

//
// class IWAnimation
//

var IWAnimation = Class.create({


    // callbackFunc takes a progress parameter in the range [0,1] and a refcon and returns nothing
    // length is the length of the animation in seconds
    //      defaulted to 1.0
    // progressFunc takes a progress parameter in the range [0,1] and returns a new progress in the     range [0,1]
    //      defaulted to linear (returns what it's passed)
    initialize: function(callbackFunc, refcon, length /* = 1.0*/, progressFunc /*= iWAnimationIdentity*/)
    {
        this.mCallback = callbackFunc;
        this.mRefCon = refcon;

        this.mFrame = 0;
        if(length == null)
        {
            length = 1.0;
        }
        this.mFrameCount = Math.ceil(length * 30);

        if(progressFunc == null)
        {
            progressFunc = iWAnimationIdentity;
        }

        // TODO -- precalculate progress
        this.mProgress = progressFunc;
    },

    start: function()
    {
        this.mCallback(0.0, this.mRefCon);
        iWAnimationAdd(this);
    //  this.mInterval = window.setInterval(iWAnimationIntervalCallback, 1000 / 30, this);
    },

    stop: function(goToEnd)
    {
        iWAnimationRemove(this);
    //  window.clearInterval(this.mInterval);
        if(goToEnd)
        {
            this.mCallback(1.0, this.mRefCon);
        }
    },


    //
    // Private Implementation
    //

    p_animate: function()
    {
        ++this.mFrame;
        if(this.mFrame > this.mFrameCount)
        {
            this.stop();
        }
        else
        {
            var progress = this.mProgress(this.mFrame / this.mFrameCount);
            this.mCallback(progress, this.mRefCon);
        }
    },

    p_reupdate: function()
    {
        var progress = this.mProgress(this.mFrame / this.mFrameCount);
        this.mCallback(progress, this.mRefCon); 
    }
});

//
// Utility Functions
//

function iWAnimationIdentity(p)
{
    return p;
}

function iWAnimationSin(p)
{
    return Math.sin(p * Math.PI / 2);
}


var iWAnimationInterval = null;
var iWAnimations = [];

function iWAnimationAdd(that)
{
    iWAnimations.push(that);

    if(iWAnimationInterval == null)
    {
        iWAnimationInterval = window.setInterval(iWAnimationsIntervalCallback, 1000 / 30);
    }
}

function iWAnimationRemove(that)
{
    // delete the element (there's got to be a better way than this
    // (brent: can't you iWAnimations.splice(i, 1) for all three cases?)
    // (brent: you might also consider using an object instead of an array and just
    //    delete iWAnimations[that] to remove.)
    for(var i = 0; i < iWAnimations.length; ++i)
    {
        if(iWAnimations[i] == that)
        {
            if(i == 0)
            {
                iWAnimations.shift();
            }
            else if(i == iWAnimations.length - 1)
            {
                iWAnimations.pop();
            }
            else
            {
                iWAnimations.splice(i, 1);
            }
            break;
        }
    }

    if(iWAnimations.length == 0)
    {
        window.clearInterval(iWAnimationInterval);
        iWAnimationInterval = null;
    }
}

function iWAnimationIntervalCallback(that)
{
    that.p_animate();
}

function iWAnimationsIntervalCallback()
{
    for(var i = 0; i < iWAnimations.length; ++i)
    {
        var oldLength = iWAnimations.length;
        iWAnimations[i].p_animate();
        if(oldLength != iWAnimations.length)
        {
            --i;
        }
    }
}

function iWAnimationsReupdate()
{
    for(var i = 0; i < iWAnimations.length; ++i)
    {
        var oldLength = iWAnimations.length;
        iWAnimations[i].p_reupdate();
        if(oldLength != iWAnimations.length)
        {
            --i;
        }
    }
}

