//
//  iWeb - WidgetConfigurator.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

var WidgetConfigurator = Class.create({
    initialize: function(hostController)
    {
        // If there is no hostController, assume this object is in use as a prototype
        // of a subclass, and don't do anything.

        if (hostController)
        {
            this.hostController = hostController;
            // set backpointer so hostController knows where we are
            this.hostController.configurator = this;
            document.configurator = this;
            this.widget = this.hostController.widget;
            if( this.widget )
            {
                this.preferences = this.widget.preferences;
            }
        }
    },

    onload: function() 
    {
    },

    onunload: function() 
    {
    },

    preferenceForKey: function(key)
    {
        return this.preferences[key];
    },

    setPreferenceForKey: function(preference, key, registerUndo/*=true*/)
    {
        if (registerUndo === undefined) 
            registerUndo = true;
    
        if ((registerUndo == false) && this.preferences.disableUndoRegistration)
            this.preferences.disableUndoRegistration();
    
        this.preferences[key] = preference;
        // the hostController will call changedPreferenceForKey(key)
    
        if ((registerUndo == false) && this.preferences.enableUndoRegistration)
            this.preferences.enableUndoRegistration();
    },

    // note: need to have included iWebJavaScriptAdditions.js to use this method.
    initializeDefaultPreferences: function(prefs)
    {
        var self = this;
        $H(prefs).each(function(pair)
        {
            if (self.preferenceForKey(pair.key) === undefined)
            {
                self.setPreferenceForKey(pair.value, pair.key, false);
            }
        });
    },

    changedPreferenceForKey: function(key)
    {
    }
});