//
//  iWeb - BlogSummaryPrivate.js
//  Copyright 2006-2008 Apple Inc. All rights reserved.
//

/* in-app only */

// NOTE: Values passed on with BLWidgetIsSafeToDrawNotification must
// conform to BLWidgetIsSafeToDrawValue enum defined in BLWidgetRep.h

BlogSummaryWidget.addMethods({
    privateInitialize: function()
    {
        var doShadows = this.disableShadows ? "disable" : "enable";
        this.setPreferenceForKey(doShadows, "x-shadow-feature", false);
    },

    setNeedsDisplay: function()
    {
        this.fetchAndRenderRSS();
    },

    privateChangedPreferenceForKey: function(key)
    {
        var value = this.preferenceForKey(key);
        var rerender = "no";

        if (["headerOnTop", "imageSizeOverride"].contains(key))
        {
            rerender = "later";
        }
        if (["excerpt-length", "imageSize", "extraSpace"].contains(key))
        {
            rerender = "now";
        }
        if (key == "refetch-rss")
        {
            this.resetRenderingState = true;
            this.fetchAndRenderRSS();
        }
    
        if ((key == "imagePosition") && (this.preferenceForKey("imageVisibility") === true))
        {
            rerender = "later";
        }
    
        if (key == "imageVisibility")
        {
            var visibility = value;
            if (visibility === null)
            {
                this.setPreferenceForKey(true, "imageVisibility");
            }
            rerender = "later";
        }
    
        if (key == "htmlTemplate")
        {
            if (this.enableSubSelection)
            {
                this.addSelectionClickHandlers();
            }
        }
            
        if (rerender == "later")
        {
            this.invalidateFeedItems(key);
        }
        else if (rerender == "now")
        {
            this.renderFeedItems(key);
        }

    },

    privateSummaryDidRender: function()
    {
        if (this.enableSubSelection)
        {
            this.addSelectionClickHandlers();
        }
    
        if (this.preferences && this.preferences.postNotification)
        {
            this.preferences.postNotification("BLWidgetIsSafeToDrawNotification", 1);        
        }    
    }
});

BlogSummaryWidget.prototype.selectableBlockRootName = "item";
BlogSummaryWidget.prototype.selectableClasses = ["Summary_Title", "Summary_Date", "Summary_Body",
    "Summary_Image", "Summary_Read_More", "Summary_Comment", "Summary_Separator"];
