//
//  iWeb - BlogSummaryShared.js
//  Copyright 2006-2008 Apple Inc. All rights reserved.
//

var BlogSummaryShared = 
{
    compileMarkup: function(markup)
    {
        // NOTE: The character '$' is special in replacement strings -- it is used for inserting matched strings, like $1 and the like.
        //       You MUST use '$$' to denote a single '$' character.
        //
        //       In the future we should stop using '$' for templates like this, it's making life unnecessarily difficult...
        
        var html = markup;
        html = html.replace(/<bl-item>/, 
            "<div id='$$WIDGET_ID-item-template' style='display:none; position: relative'>");
        html = html.replace(/<\/bl-item>/,"</div>");
        html = html.replace(/<bl-image\/>/,
            "<div id='$$WIDGET_ID-image' class='Summary_Image'><a href='$$link$$'><div id='$$WIDGET_ID-image-group' style='position:relative' >"
            + "</div></a></div>");

        html = html.replace(/<bl-header>/, "<div id='$$WIDGET_ID-header'>");
        html = html.replace(/<\/bl-header>/, "</div>");
    
        html = html.replace(/<bl-title\/>/, "<bl-title><a href='$$link$$'>@title@</a></div>");
        html = html.replace(/<bl-title>/, "<div id='$$WIDGET_ID-title' class='Summary_Title'>");
        html = html.replace(/<\/bl-title>/, "</div>");
    
        html = html.replace(/<bl-date\/>/, "<bl-date>@date@</bl-date>");
        html = html.replace(/<bl-date>/, "<div id='$$WIDGET_ID-date' class='Summary_Date'>");
        html = html.replace(/<\/bl-date>/, "</div>");

        html = html.replace(/<bl-excerpt\/>/, "<bl-excerpt>@excerpt@</bl-excerpt>");
        html = html.replace(/<bl-excerpt>/, "<div id='$$WIDGET_ID-excerpt' class='Summary_Body'>");
        html = html.replace(/<\/bl-excerpt>/, "</div>");
    
        html = html.replace(/<bl-comment>/, "<div id='$$WIDGET_ID-comment' class='Summary_Comment'>");
        html = html.replace(/<\/bl-comment>/, "</div>");

        html = html.replace(/<bl-link>/,"<div id='$$WIDGET_ID-link' class='Summary_Read_More'>");
        html = html.replace(/<\/bl-link>/,"</div>");
    
        html = html.replace(/<bl-separator>/, "<div id='$$WIDGET_ID-separator-template' class='Summary_Separator' style='display:none'>");
        html = html.replace(/<\/bl-separator>/, "</div>");
    
        html = html.replace(/<bl-comment-field>/, "<span id='$$WIDGET_ID-comment-field' class='comment-field' style='display:none'>");
        html = html.replace(/<\/bl-comment-field>/, "</span>");
    
        html = html.replace(/<bl-comment-count\/>/, "<a href='$$comment-link$$'>@comment-count@</a>");

        html = html.replace(/@title@/g, "<span class='bl-value-title'></span>");
        html = html.replace(/@date@/g, "<span class='bl-value-date'></span>");
        html = html.replace(/@excerpt@/g, "<span class='bl-value-excerpt'></span>");
        html = html.replace(/@comment-count@/g, "<span class='bl-value-comment-count'></span>");

        html = html.replace(/<localized>/g, "<span class='bl-localized'>");
        html = html.replace(/<\/localized>/g, "</span>");
    
        return html;
    },

    defaultSummaryMarkup:
        "<bl-item>\n" +
          "<bl-image/>\n" +
          "<bl-header>\n" +
            "<bl-date/>\n" +
            "<bl-title/>\n" +
          "</bl-header>\n" +
          "<bl-excerpt/>\n" +
          "<div style='clear:both'></div>\n" +
          "<bl-link><a href='$link$'><localized>Read more...</localized></a>\n" +
            "<bl-comment-field> | <bl-comment-count/></bl-comment-field></bl-link>\n" +
        "</bl-item>\n" +

        "<bl-separator>\n" +
          "<hr size='4' width='35%'/>\n" +
        "</bl-separator>\n",

    defaultArchiveMarkup:
        "<bl-item>\n" +
          "<bl-date/>\n" +
          "<bl-title/>\n" +
          "<bl-link><a href='$link$'><localized>Read more...</localized></a>\n" +
            "<bl-comment-field> | <bl-comment-count/></bl-comment-field></bl-link>\n" +
        "</bl-item>\n" +

        "<bl-separator>\n" +
          "<hr size='4' width='35%'/>\n" +
        "</bl-separator>\n"
};
