//
//  iWeb - HUD.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

var BlogSummaryHUD = Class.create(WidgetConfigurator, {

    widgetIdentifier: "com-apple-iweb-widget-blogSummary",

    initialize: function($super, hostController)
    {
        if (hostController)
        {
            $super(hostController);

            document.blogSummaryHUD = this;
        
            if (this.preferenceForKey("x-hasDoneFirstTimeInit") === undefined)
            {
                this.isInitializingPreferences = true
                this.compileAndSendTemplateToWidget();
                this.initializeDefaultPreferences({
                    "x-designerControls": false,
                    "x-hasDoneFirstTimeInit": true
                });
                delete this.isInitializingPreferences;
            }
        }
    },

    sourceMarkupOrDefault: function()
    {
        var markup = this.preferenceForKey("x-htmlTemplate");
        if ((markup === undefined) || (markup == ""))
        {
            if (this.preferenceForKey("rss-for-archive"))
            {
                markup = BlogSummaryShared.defaultArchiveMarkup;
            }
            else
            {
                markup = BlogSummaryShared.defaultSummaryMarkup;
            }
            this.setPreferenceForKey(markup, "x-htmlTemplate");
        }
        return markup;
    },

    buildHUDControls: function()
    {
        var self = this;
    
        var showPhotoCheckbox = new Checkbox("Show Photo", "showPhoto", this.preferenceForKey("imageVisibility"), 
            function()
            {
                if (self.preferenceForKey("imageVisibility") != this.value)
                    self.setPreferenceForKey(this.value, "imageVisibility");
            });

        $("spanShowPhoto").appendChild(showPhotoCheckbox.element);
    
        var imageSizeSlider = new Slider("", "imageSize", 10, 100, 25,
            function()
            {
                if (self.preferenceForKey("imageSize") != this.value)
                    self.setPreferenceForKey(this.value, "imageSize");
            }, /* show value */ false );
        $("spanImageSize").appendChild(imageSizeSlider.element);
    
        /*
        var extraSpaceSlider = new Slider("", "extraSpace", 0, 50, 0,
            function() {
                if (self.preferenceForKey("extraSpace") != this.value)
                    self.setPreferenceForKey(this.value, "extraSpace");
            },  false // show value
        );
        $("spanExtraSpace").appendChild(extraSpaceSlider.element);
        */
 
         self.extraSpace = 0;
         new Stepper(
            $("spanExtraSpace"), 13, 18, 
            "HUD-SpinnerTop-N.tiff", "HUD-SpinnerTop-P.tiff", 9,
            "HUD-SpinnerBottom-N.tiff", "HUD-SpinnerBottom-P.tiff", 9,
            function() {self.extraSpaceAdj(1); }, function() {self.extraSpaceAdj(-1);});
    
    
        var photoProportionsPopup = new Popup("", "photoProportions", ["Original", "Square", "Landscape", "Portrait"],
            function()
            {
                if (self.preferenceForKey("photoProportions") != this.value)
                    self.setPreferenceForKey(this.value, "photoProportions");
            });

        var buttonURLs = new Array("","BS-Layout-1.tiff", "BS-Layout-2.tiff","BS-Layout-3.tiff","BS-Layout-4.tiff","BS-Layout-5.tiff");
        $("spanPhotoProportions").appendChild(photoProportionsPopup.element);
        self.layoutKind=1;
        self.addLayoutImageButton(buttonURLs[self.layoutKind]);
        self.setLayoutKind(self.layoutKind);
    
        /* make the triangle popup */
        var layoutPopup = new ImageButton("layoutPopup", "HUD-Menu-DisclosureArrow.tiff", 7, 
            function() {
                self.layoutKind += 1;
                if (self.layoutKind == 6) {self.layoutKind=1;}
                self.setLayoutKind( self.layoutKind );
                self.addLayoutImageButton(buttonURLs[self.layoutKind]);
            });
        $("spanLayoutPopupTriangle").appendChild(layoutPopup.element);


        var extraSpaceEdit = new ImageButton("extraSpaceEditBox", "HUD-edit-box.tiff", 39, 
            function() { // should jump to edit mode
            });

        $("spanExtraSpaceEdit").appendChild(extraSpaceEdit.element);


        /* inspector link button */
    
        var iLinkButton = new ImageButton("iLinkButton", "HUD-Inspector.tiff", 14, function() {});
        $("spanInspectorLink").appendChild(iLinkButton.element);

        var designerMode =1  // temp hack - need preferenceForKey

        if (designerMode)
        {
            var designerControlsCheckbox = new Checkbox("Designer Controls", "designerControls", this.preferenceForKey("x-designerControls"), 
                function()
                {
                    self.setPreferenceForKey(this.value, "x-designerControls");
                });
            $("spanDesignerControls").appendChild(designerControlsCheckbox.element);
        }
    },

    extraSpaceAdj: function(moreExtraSpace)
    {
        var min = 0;
        var max = 45;
        var extra = this.extraSpace + moreExtraSpace*3;
        if (extra < min) {extra = min; }
        if (extra > max) {extra = max; }
        this.setExtraSpace(extra);
    },

    setExtraSpace: function(extraSpace)
    {
        this.extraSpace = extraSpace;
         var elem = $("spanExtraSpaceValue");
         elem.innerText = "" + extraSpace;
        //var textNode = document.createTextNode("" + extraSpace);
        //elem.firstChild.replaceChild(textNode, elem.firstChild);
         this.setPreferenceForKey(extraSpace, "extraSpace");
    },

    addLayoutImageButton: function(imageFile)
    {
        var elem = $("spanLayout1");
        var childnodes = elem.childNodes;
        if (childnodes.length > 0) { elem.removeChild(childnodes[0]); }
        var layout1Button = new ImageButton("layout1", imageFile, 78, function() {});
        elem.appendChild(layout1Button.element);
    },

    setLayoutKind: function(kind)
    {
        if (kind == 1)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(true, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 2)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 3)
        {
            this.setPreferenceForKey(true, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 4)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Right", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 5)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(true, "headerOnTop");
            this.setPreferenceForKey(100, "imageSizeOverride");
        }
    },

    // Update the UI to reflect changes to preferences.
    //
    changedPreferenceForKey: function(key)
    {
        if (this.isInitializingPreferences)
        {
            return;
        }
    
        if (key == "x-htmlTemplate")
        {
            var preferenceValue = this.sourceMarkupOrDefault();
            var controlValue = $(key).value;
            if (controlValue != preferenceValue)
            {
                $(key).value = preferenceValue;
            }
            this.compileAndSendTemplateToWidget();
            return;
        }
    
        var newValue = this.preferenceForKey(key);
    
        if (key == "imageVisibility")
        {
            var showPhotoCheckbox = document.checkbox["showPhoto"];
            showPhotoCheckbox.setValue(newValue);
        }
        if (key == "imageSize")
        {
            var imageSizeSlider = document.slider["imageSize"];
            imageSizeSlider.setValue(newValue);
        }
    
        if (key == "extraSpace")
        {
           // var extraSpaceSlider = document.slider["extraSpace"];
            //extraSpaceSlider.setValue(newValue);
        }
    
        if (key == "rss-for-archive")
        {
            $("rss-for-archive").checked = newValue;
        }
    
        if (key == "x-designerControls")
        {
            if (newValue)
            {
                this.animation = new HUDResizeAnimation(new IWSize(470, 640), function()
                {
                    $("divDesignerControls").style.display = "";
                });
            }
            else
            {
                $("divDesignerControls").style.display = "none";
                this.animation = new HUDResizeAnimation(new IWSize(270, 200), function()
                {
                });
            }
            this.animation.start();
        }

        if (key == "photoProportions")
        {
            var photoProportionsPopup = document.popup["photoProportions"];
            photoProportionsPopup.setValue(newValue);
        }
    },

    onload: function()
    {
        this.buildHUDControls();
    
        this.changedPreferenceForKey("imagePosition");
        this.changedPreferenceForKey("imageVisibility");
        this.changedPreferenceForKey("imageSize");
        this.changedPreferenceForKey("rss-for-archive");
        this.changedPreferenceForKey("extraSpace");
        this.changedPreferenceForKey("photoProportions");
        this.changedPreferenceForKey("x-htmlTemplate");
        this.changedPreferenceForKey("x-designerControls");
    
        this.rebuildInstanceAssetDisplay();
    },

    compileAndSendTemplateToWidget: function()
    {
        var markup = this.sourceMarkupOrDefault();
    
        var html = BlogSummaryShared.compileMarkup(markup);
        $("x-compiledHtml").value = html;
    
        var oldHtml = this.preferenceForKey("htmlTemplate");
        if (oldHtml != html)
        {
            this.setPreferenceForKey(html, "htmlTemplate", false);
        }
    },

    //
    // Instance Asset Stuff
    //

    addInstanceAsset: function()
    {
        if (this.fileInput)
        {
            var path = this.fileInput.value;
            if( path )
            {
                this.preferences.addInstanceAssetWithPath(path);
                this.rebuildInstanceAssetsAndRedisplay();
            }
        }
    },

    removeInstanceAsset: function(button)
    {
        var name = button.assetName;
        if (name)
        {
            this.preferences.removeInstanceAssetWithName(name);    
            this.rebuildInstanceAssetsAndRedisplay();
        }
    },

    removeAllInstanceAssets: function()
    {
        this.preferences.removeAllInstanceAssets();
        this.rebuildInstanceAssetsAndRedisplay();
    },

    rebuildInstanceAssetDisplay: function()
    {
        var containingDiv = $("instanceAssets");
        if (containingDiv)
        {
            // remove 'em all
            while (containingDiv.hasChildNodes())
            {
                containingDiv.removeChild(containingDiv.firstChild);
            }
        
            var templateDiv = $("templateInstanceAsset");
            if (templateDiv)
            {        
                // add 'em again
                var names = this.preferences.instanceAssetNames();            
                var urls = this.preferences.instanceAssetURLStrings();
                for (var i=0; i < names.length; i++)
                {
                    var clone = $(templateDiv.cloneNode(true));    // deep clone
                
                    clone.id = undefined;
                    clone.className = "instanceAsset";

                    var spans = clone.select('span');
                    if (spans.length > 0)
                    {
                        var textNode = document.createTextNode(names[i]);
                        spans[0].insertBefore(textNode, null);
                    }
                
                    var imgs = clone.select('img');
                    if (imgs.length > 0)
                    {
                        imgs[0].src = urls[i];        
                    }
                
                    var buttons = clone.select('input');
                    if( buttons.length > 0 )
                    {
                        buttons[0].assetName = names[i];
                    }
                
                    containingDiv.insertBefore(clone, null);    
                }
            }
        }   
    
        var fileInputPara = $("fileInputParagraph");
        var fileInputTemplate = $("templateFileInput");
        if (fileInputPara && fileInputTemplate)
        {
            // we can't get the <input type="file"> to reset -- seems like a Safari bug --
            // so replace it with a clean new clone that has never had a value set on it
            var clone = fileInputTemplate.cloneNode(true); // deep
            if (clone)
            {
                clone.id = undefined;
                if (this.fileInput)
                {
                    fileInputPara.replaceChild(clone, this.fileInput);
                }
                else
                {
                    fileInputPara.insertBefore(clone, fileInputPara.firstChild);                
                }
                this.fileInput = clone;
            }            
        }
    },

    rebuildInstanceAssetsAndRedisplay: function()
    {
        this.rebuildInstanceAssetDisplay();
    
        // refresh the display in the widget itself
        this.compileAndSendTemplateToWidget();
    },

    //
    // HUD Event Handlers
    //
    // Event handlers should not update the UI directly; they should modify the preferences
    // and let the preferenceChangedForKey method update the UI.

    clickArchiveSelectCheckbox: function()
    {
        var isArchive = $("rss-for-archive").checked;
        this.setPreferenceForKey(isArchive, "rss-for-archive");
    },

    // Read HTML template value from control. Write raw value to "x-" preference, and
    // write processed template to preferences so the widget can update.
    //
    applyMarkup: function()
    {
        var html = $("x-htmlTemplate").value;
        this.setPreferenceForKey(html, "x-htmlTemplate");
    }
});



//
// HUDResizeAnimation
//

var HUDResizeAnimation = Class.create({
    initialize: function(size, finished)
    {
        this.startSize = new IWSize(window.outerWidth, window.outerHeight);
        this.sizeDelta = size.subtractSize(this.startSize);
        this.finishedFunc = finished;
        var self = this;
        this.animation = new IWAnimation(function(step)
            {
                window.resizeTo(self.startSize.width + step * self.sizeDelta.width,
                                self.startSize.height + step * self.sizeDelta.height);
                if (step == 1.0)
                {
                    self.finishedFunc();
                }
            }, 0, 0.25);
    },

    start: function()
    {
        this.animation.start();
    },

    stop: function()
    {
        this.animation.stop();
    }
});
