//
//  iWeb - CommentsPrivate.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

/* in-app only */

// NOTE: Values passed on with BLWidgetIsSafeToDrawNotification must
// conform to BLWidgetIsSafeToDrawValue enum defined in BLWidgetRep.h

CommentsWidget.addMethods({
    onunload: function()
    {
        // todo: this doesn't seem to be called, but it would be quite convenient.
    },

    privateChangedPreferenceForKey: function(key)
    {
        var value = this.preferenceForKey(key);
        var rerender = "no";
    
        if (key == "allowComments")
        {
            if (this.data && this.data.items)
            {
                this.data.commentsEnabled = value;
                this.renderCommentItems('enable change');
            }
        }
    },

    setNeedsDisplay: function()
    {
        this.fetchAndRenderComments();
    },

    privateCommentsDidRender: function()
    {
        if (this.preferences && this.preferences.postNotification)
        {
            this.preferences.postNotification("BLWidgetIsSafeToDrawNotification", 1);        
        }    
    },

    getStyleElement: function(key)
    {
        // create a style element in the document's head, if we haven't already made one
        if (!this.styleElement)
        {
            var head = document.getElementsByTagName("head")[0];
            if( head )
            {
                var newElement = document.createElement("style");
                newElement.type = "text/css";
                head.appendChild(newElement);
                this.styleElement = newElement;
            }
        }
        
        return this.styleElement;        
    }

});