//
//  iWeb - CommentsShared.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

var CommentsShared = 
{
    compileMarkup: function(markup)
    {
         // NOTE: The character '$' is special in replacement strings -- it is used for inserting matched strings, like $1 and the like.
         //       You MUST use '$$' to denote a single '$' character.
         //
         //       In the future we should stop using '$' for templates like this, it's making life unnecessarily difficult...
        
        var html = markup;

        html = html.replace(/<comment-item>/, 
            "<div id='$$WIDGET_ID-item' style='display:none; position: relative'>");
        html = html.replace(/<\/comment-item>/,"</div>");

        html = html.replace(/<comment-header>/, "<div id='$$WIDGET_ID-header' class='Comment_Header'>");
        html = html.replace(/<\/comment-header>/, "</div>");

        html = html.replace(/<comment-footer>/, "<div id='$$WIDGET_ID-footer' class='Comment_Footer'>");
        html = html.replace(/<\/comment-footer>/, "</div>");

        html = html.replace(/<comment-author\/>/, "<comment-author>@author@</comment-author>");
        html = html.replace(/<comment-author>/, "<div id='$$WIDGET_ID-author' class='Comment_Author'>");
        html = html.replace(/<\/comment-author>/, "</div>");

        html = html.replace(/<comment-date\/>/, "<comment-date>@date@</comment-date>");
        html = html.replace(/<comment-date>/, "<div id='$$WIDGET_ID-date' class='Comment_Posted_Date'>");
        html = html.replace(/<\/comment-date>/, "</div>");

        html = html.replace(/<comment-body\/>/, "<comment-body>@body@</comment-body>");
        html = html.replace(/<comment-body>/, "<div id='$$WIDGET_ID-body' class='Comment_Body'>");
        html = html.replace(/<\/comment-body>/, "</div>");

        html = html.replace(/<comment-attachment\/>/, "<comment-attachment>" + 
                                                        "<a href='$$attachment-url$$' title='$$attachment-tooltip$$'>" + 
                                                          "<img -src='$$preview-url$$' /><span id='$$WIDGET_ID-attachment-file-info'>@file-info@</span>" +
                                                        "</a>"+
                                                      "</comment-attachment>");
        html = html.replace(/<comment-attachment>/, "<div id='$$WIDGET_ID-attachment' class='Comment_Attachment_Caption'>");
        html = html.replace(/<\/comment-attachment>/, "</div>");


        html = html.replace(/<comment-separator>/, "<div id='$$WIDGET_ID-separator' class='Comment_Separator' style='display:none'>");
        html = html.replace(/<\/comment-separator>/, "</div>");

        html = html.replace(/@author@/g, "<span class='comment-value-author'></span>");
        html = html.replace(/@date@/g, "<span class='comment-value-date'></span>");
        html = html.replace(/@body@/g, "<span class='comment-value-body'></span>");
        html = html.replace(/@comment-count@/g, "<span class='comment-value-comment-count'></span>");
        html = html.replace(/@comment-manage-light@/g, "<a class='comment-manage-link' href='$$manage-app-url$$'>"+
                                                         "<img -src='$$WIDGET_PATH/lockIcon_light.png' alt='$$manage-tooltip$$' title='$$manage-tooltip$$' />"+
                                                       "</a>");
        html = html.replace(/@comment-manage-dark@/g, "<a class='comment-manage-link' href='$$manage-app-url$$'>"+
                                                        "<img -src='$$WIDGET_PATH/lockIcon_dark.png' alt='$$manage-tooltip$$' title='$$manage-tooltip$$' />"+
                                                      "</a>");
        html = html.replace(/@post@/g, "<a class='comment-post'><localized>Add a Comment</localized></a>");
        html = html.replace(/@file-info@/g, "<span class='comment-value-file-info'></span>");

        html = html.replace(/<localized>/g, "<span class='comment-localized'>");
        html = html.replace(/<\/localized>/g, "</span>");
    
        return html;
    },
    
    defaultSourceMarkup:
        "<comment-header>@comment-count@ @comment-manage-dark@<hr/>" +
        "</comment-header>\n" +
        "<comment-item>\n" +
          "<comment-date/>\n" +
          "<comment-author/>\n" +
          "<comment-body/>\n" +
          "<comment-attachment/>\n" +
        "</comment-item>\n" +
        "<comment-separator>\n" +
          "<hr size='4' width='35%'/>\n" +
        "</comment-separator>\n" +
        "<comment-footer><hr/>\n" +
        "@post@ @comment-manage-dark@\n" +
        "</comment-footer>"
};
