//
//  iWeb - HUD.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

var CommentsHUD = Class.create(WidgetConfigurator, {

    widgetIdentifier: "com-apple-iweb-widget-comments",

    initialize: function($super, hostController)
    {
        if (hostController)
        {
            $super(hostController);
            document.CommentsHUD = this;
        
            if (this.preferenceForKey("x-hasDoneFirstTimeInit") === undefined)
            {
                this.isInitializingPreferences = true
                this.compileAndSendTemplateToWidget();
                this.initializeDefaultPreferences({
                    "x-designerControls": false,
                    "x-hasDoneFirstTimeInit": true
                });
                delete this.isInitializingPreferences;
            }
        }
    },

    sourceMarkupOrDefault: function()
    {
        var html = this.preferenceForKey("x-htmlTemplate");
        if ((html === undefined) || (html == ""))
        {
            html = CommentsShared.defaultSourceMarkup;
            this.setPreferenceForKey(html, "x-htmlTemplate");
        }
        return html;
    },

    setLayoutKind: function(kind)
    {
        if (kind == 1)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(true, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 2)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 3)
        {
            this.setPreferenceForKey(true, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 4)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Right", "imagePosition");
            this.setPreferenceForKey(false, "headerOnTop");
            this.setPreferenceForKey("", "imageSizeOverride");
        }
        else if (kind == 5)
        {
            this.setPreferenceForKey(false, "imageOutside");
            this.setPreferenceForKey("Left", "imagePosition");
            this.setPreferenceForKey(true, "headerOnTop");
            this.setPreferenceForKey(100, "imageSizeOverride");
        }
    },

    // Update the UI to reflect changes to preferences.
    //
    changedPreferenceForKey: function(key)
    {
        if (this.isInitializingPreferences)
        {
            return;
        }
    
        if (key == "x-htmlTemplate")
        {
            var preferenceValue = this.sourceMarkupOrDefault();
            var controlValue = $(key).value;
            if (controlValue != preferenceValue)
            {
                $(key).value = preferenceValue;
            }
            this.compileAndSendTemplateToWidget();
            return;
        }
    
        var newValue = this.preferenceForKey(key);
    },

    onload: function()
    {
        this.changedPreferenceForKey("x-htmlTemplate");
        this.rebuildInstanceAssetDisplay();
    },

    compileAndSendTemplateToWidget: function()
    {
        var markup = this.sourceMarkupOrDefault();
        var html = CommentsShared.compileMarkup(markup);
        $("x-compiledHtml").value = html;
    
        var oldHtml = this.preferenceForKey("htmlTemplate");
        if (oldHtml != html)
        {
            this.setPreferenceForKey(html, "htmlTemplate", false);
        }
    },

    //
    // Instance Asset Stuff
    //

    addInstanceAsset: function()
    {
        if (this.fileInput)
        {
            var path = this.fileInput.value;
            if( path )
            {
                this.preferences.addInstanceAssetWithPath(path);
                this.rebuildInstanceAssetsAndRedisplay();
            }
        }
    },

    removeInstanceAsset: function(button)
    {
        var name = button.assetName;
        if (name)
        {
            this.preferences.removeInstanceAssetWithName(name);    
            this.rebuildInstanceAssetsAndRedisplay();
        }
    },

    removeAllInstanceAssets: function()
    {
        this.preferences.removeAllInstanceAssets();
        this.rebuildInstanceAssetsAndRedisplay();
    },

    rebuildInstanceAssetDisplay: function()
    {
        var containingDiv = $("instanceAssets");
        if (containingDiv)
        {
            // remove 'em all
            while (containingDiv.hasChildNodes())
            {
                containingDiv.removeChild(containingDiv.firstChild);
            }
        
            var templateDiv = $("templateInstanceAsset");
            if (templateDiv)
            {        
                // add 'em again
                var names = this.preferences.instanceAssetNames();            
                var urls = this.preferences.instanceAssetURLStrings();
                for (var i=0; i < names.length; i++)
                {
                    var clone = $(templateDiv.cloneNode(true));    // deep clone
                
                    clone.id = undefined;
                    clone.className = "instanceAsset";

                    var spans = clone.select('span');
                    if (spans.length > 0)
                    {
                        var textNode = document.createTextNode(names[i]);
                        spans[0].insertBefore(textNode, null);
                    }
                
                    var imgs = clone.select('img');
                    if (imgs.length > 0)
                    {
                        imgs[0].src = urls[i];        
                    }
                
                    var buttons = clone.select('input');
                    if( buttons.length > 0 )
                    {
                        buttons[0].assetName = names[i];
                    }
                
                    containingDiv.insertBefore(clone, null);    
                }
            }
        }   
    
        var fileInputPara = $("fileInputParagraph");
        var fileInputTemplate = $("templateFileInput");
        if (fileInputPara && fileInputTemplate)
        {
            // we can't get the <input type="file"> to reset -- seems like a Safari bug --
            // so replace it with a clean new clone that has never had a value set on it
            var clone = fileInputTemplate.cloneNode(true); // deep
            if (clone)
            {
                clone.id = undefined;
                if (this.fileInput)
                {
                    fileInputPara.replaceChild(clone, this.fileInput);
                }
                else
                {
                    fileInputPara.insertBefore(clone, fileInputPara.firstChild);                
                }
                this.fileInput = clone;
            }            
        }
    },

    rebuildInstanceAssetsAndRedisplay: function()
    {
        this.rebuildInstanceAssetDisplay();
    
        // refresh the display in the widget itself
        this.compileAndSendTemplateToWidget();
    },

    //
    // HUD Event Handlers
    //
    // Event handlers should not update the UI directly; they should modify the preferences
    // and let the preferenceChangedForKey method update the UI.

    clickArchiveSelectCheckbox: function()
    {
        var isArchive = $("rss-for-archive").checked;
        this.setPreferenceForKey(isArchive, "rss-for-archive");
    },

    // Read HTML template value from control. Write raw value to "x-" preference, and
    // write processed template to preferences so the widget can update.
    //
    applyHTML: function()
    {
        var html = $("x-htmlTemplate").value;
        this.setPreferenceForKey(html, "x-htmlTemplate");
    }
});



