//
//  iWeb - FooterControls.js
//  Copyright (c) 2007-2008 Apple Inc. All rights reserved.
//

// NOTE: Values passed on with BLWidgetIsSafeToDrawNotification must
// conform to BLWidgetIsSafeToDrawValue enum defined in BLWidgetRep.h

//
// FooterControls
//
var FooterControls = Class.create(Widget, {

    widgetIdentifier: "com-apple-iweb-widget-footercontrols",

    initialize: function($super, instanceID, widgetPath, sharedPath, sitePath, preferences, runningInApp)
    {
        if(instanceID != null)
        {
            $super(instanceID, widgetPath, sharedPath, sitePath, preferences, runningInApp);
            NotificationCenter.addObserver(this, FooterControls.prototype.p_handlePaginationContentsNotification, "paginationSpanContents", this.p_mediaGridID());
            this.updateFromPreferences();
        }
    },

    onload: function() 
    {
        if (this.preferences && this.preferences.postNotification)
        {
            this.preferences.postNotification("BLWidgetIsSafeToDrawNotification", 1);        
        }
    },

    onunload: function() 
    {
    },

    updateFromPreferences: function()
    {
        // Semi-bogus.  If the header controls are initialized before us, we may not get an initial
        // notification containing the pagination contents when the page is first displayed in-app.
        // Send a notification of our own to ping the header.
        this.setPage(0);
    },

    changedPreferenceForKey: function(key)
    {
        if(this.runningInApp)
        {
            // When running in-app, the footer control gets its content directly from the header
            // via the shared prefs model.
            if(key == "x-paginationSpanContents")
            {
                this.p_setPaginationControls(this.p_paginationSpanContents());
            }
        }
    },

    // In-app, prev- next- and set- page methods operate via the shared prefs model.
    // When published, they operate via notifications.
    // In both cases, the range calculations are all performed by the header control
    // and communicated back to the footer widget.  The footer is just a dummy
    // widget that displays whatever is delivered by the header.
    prevPage: function()
    {
        if(this.runningInApp)
        {
            this.setPreferenceForKey(null, "x-previousPage");
        }
        else
        {
            NotificationCenter.postNotification(new IWNotification("PreviousPage", this.p_mediaGridID(), null));
        }
    },

    nextPage: function()
    {
        if(this.runningInApp)
        {
            this.setPreferenceForKey(null, "x-nextPage");
        }
        else
        {
            NotificationCenter.postNotification(new IWNotification("NextPage", this.p_mediaGridID(), null));
        }
    },

    setPage: function(pageIndex)
    {
        if(this.runningInApp)
        {
            this.setPreferenceForKey(pageIndex, "x-setPage");
        }
        else
        {
            NotificationCenter.postNotification(new IWNotification("SetPage", this.p_mediaGridID(), {pageIndex: pageIndex}));
        }
    },

    //
    // Private accessors
    //

    p_mediaGridID: function()
    {
        var mediaGridID = null;

        if(this.preferences)
        {
            mediaGridID = this.preferenceForKey("gridID");
        }

        if(mediaGridID === undefined)
        {
            mediaGridID = null;
        }

        return mediaGridID;
    },

    p_paginationSpanContents: function()
    {
        var paginationSpanContents = null;

        if(this.preferences)
        {
            paginationSpanContents = this.preferenceForKey("x-paginationSpanContents");
        }

        if(paginationSpanContents === undefined)
        {
            paginationSpanContents = null;
        }

        return paginationSpanContents;
    },

    p_handlePaginationContentsNotification: function(notification)
    {
        var userInfo = notification.userInfo();
        var controls = userInfo.controls || "";
        this.p_setPaginationControls(controls);
    },

    p_setPaginationControls: function(controls)
    {
        // The pagination span contents are delivered either via the shared prefs model
        // or via a notification.  In either case, we need to substitute in our own 
        // widget id, and update the span.
        var template = new Template(controls);
        var myControls = template.evaluate({WIDGET_ID: this.instanceID});
        this.getElementById("pagination_controls").update(myControls);
    }
});
