// iWeb - GoogleAds.js
// Copyright (c) 2007-2008 Apple, Inc.
// All rights reserved.
//

// Responsibility: rudy
// Reviewers: mmurrett

// NOTE: Values passed on with BLWidgetIsSafeToDrawNotification must
// conform to BLWidgetIsSafeToDrawValue enum defined in BLWidgetRep.h

var GoogleAds = Class.create(Widget, {

    widgetIdentifier: "com-apple-iweb-widget-googleads",

    initialize: function($super, instanceID, widgetPath, sharedPath, sitePath, preferences, runningInApp)
    {
        if(instanceID != null)
        {
            $super(instanceID, widgetPath, sharedPath, sitePath, preferences, runningInApp);
            this.updateFromPreferences();
        }
    },

    onload: function() 
    {
        if (this.preferences && this.preferences.postNotification)
        {
            this.preferences.postNotification("BLWidgetIsSafeToDrawNotification", 1);        
        }
    },

    onunload: function() 
    {
    },

    startup: function()
    {
        if (this.preferences && this.preferences.postNotification)
        {
            this.setWidgetFormatFromPreferences();
        
            this.setWidgetWidthFromPreferences();
            this.setWidgetHeightFromPreferences();

            this.setWidgetTitleColorFromPreferences();
            this.setWidgetBorderColorFromPreferences();
            this.setWidgetTextColorFromPreferences();
            this.setWidgetBackgroundColorFromPreferences();
            this.setWidgetBackgroundImageFromPreferences();
        
            this.preferences.postNotification("BLWidgetShouldStartAutoSizingNotification", 1);
        }    
    },

    updateFromPreferences: function()
    {
        this.startup();
    },

    changedPreferenceForKey: function(key)
    {
        if(this.runningInApp)
        {
            if(key == "adFormatTiny")
            {
                this.setWidgetFormatFromPreferences();
            
                // also need to reset colors
            
                this.setWidgetTitleColorFromPreferences();
                this.setWidgetBorderColorFromPreferences();
                this.setWidgetTextColorFromPreferences();
                this.setWidgetBackgroundColorFromPreferences();
                this.setWidgetBackgroundImageFromPreferences();
            }
            else if(key == "adWidth")
            {
                this.setWidgetWidthFromPreferences();
            }
            else if(key == "adHeight")
            {
                this.setWidgetHeightFromPreferences();
            }
            else if(key == "adTitleColor")
            {
                this.setWidgetTitleColorFromPreferences();
            }
            else if(key == "adBorderColor")
            {
                this.setWidgetBorderColorFromPreferences();
            }
            else if(key == "adTextColor")
            {
                this.setWidgetTextColorFromPreferences();
            }
            else if(key == "adBackgroundColor")
            {
                this.setWidgetBackgroundColorFromPreferences();
            }
            else if(key == "backgroundImage")
            {
                this.setWidgetBackgroundImageFromPreferences();
            }

            this.preferences.postNotification("BLWidgetShouldStartAutoSizingNotification", 1);        
        }
    },

    setWidgetFormatFromPreferences: function()
    {
        this.getElementById('google-ad-type').className = this.preferenceForKey("adFormatTiny") ? 'google-ad-tiny' : 'google-ad-big';
    },

    setWidgetBackgroundImageFromPreferences: function()
    {
        // need the form google-ad-background-[big/tiny]-[color]
        
        var name = "google-ad-background-" + ( this.preferenceForKey("adFormatTiny") ? "tiny-" : "big-" ) + this.preferenceForKey("backgroundImage");
        this.getElementById('google-ad-background').className = name;
    },
    
    setWidgetTitleColorFromPreferences: function()
    {
        this.getElementById('google-ad-title').style.color = this.preferenceForKey("adTitleColor");
    },

    setWidgetTextColorFromPreferences: function()
    {
        this.getElementById('google-ad-body').style.color = this.preferenceForKey("adTextColor");
    },

    setWidgetBorderColorFromPreferences: function()
    {
        this.getElementById('google-ad-type').style.border = "thin" + " " + "solid" + " " + this.preferenceForKey("adBorderColor");
        this.getElementById('google-ad-type').style.backgroundColor = this.preferenceForKey("adBorderColor");
    },

    setWidgetBackgroundColorFromPreferences: function()
    {
        this.getElementById('google-ad-type').style.backgroundColor = this.preferenceForKey("adBackgroundColor");
    },

    setWidgetWidthFromPreferences: function()
    {
        var element = this.getElementById('google-ad-type');
        var width = this.preferenceForKey("adWidth");

        var leftPadding = element.style.paddingLeft;
        var rightPadding = element.style.paddingRight;
        width -= 4 + parseFloat( leftPadding || 0 ) + parseFloat( rightPadding || 0 );
        element.style.width = px(width);
    },

    setWidgetHeightFromPreferences: function()
    {
        var element = this.getElementById('google-ad-type');
        var height = this.preferenceForKey("adHeight");
    
        var topPadding = element.style.paddingTop;
        var bottomPadding = element.style.paddingBottom;
        height -= 4 + parseFloat( topPadding || 0 ) + parseFloat( bottomPadding || 0 );
        element.style.height = px(height);
    }
});
