// Test URL parsing
var scrapeURL = YouTubeWidget.prototype.p_scrapeYouTubeURLFromString;
var scrapeGUID = YouTubeWidget.prototype.p_scrapeVideoGUIDFromString;

// URL Scraping.
IWUTAssert( (scrapeURL('foo') != null), "Scrape should not return null" );
IWUTAssert( (scrapeURL('foo') == 'foo'), "Could not scrape simple URL" );
IWUTAssert( (scrapeURL(' bar\t\n') == 'bar'), "URL scraping should strip whitespace" );
IWUTAssert( (scrapeURL('http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1') == 'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1'), "Scrape URL failure (1)" );
IWUTAssert( (scrapeURL('http://www.youtube.com/v/9kErrPOK94k?hl=en&color1=0x402061&color2=0x9461ca&border=1') == 'http://www.youtube.com/v/9kErrPOK94k?hl=en&color1=0x402061&color2=0x9461ca&border=1'), "Scrape URL failure (2)" );
IWUTAssert( (scrapeURL('http://www.youtube.com/v/9kErrPOK94k/?hl=en&color1=0x402061&color2=0x9461ca&border=1') == 'http://www.youtube.com/v/9kErrPOK94k/?hl=en&color1=0x402061&color2=0x9461ca&border=1'), "Scrape URL failure (3)" );
IWUTAssert( (scrapeURL('<object width="425" height="349"><param name="movie" value="http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1"></param><param name="allowFullScreen" value="true"></param><embed src="http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1" type="application/x-shockwave-flash" allowfullscreen="true" width="425" height="349"></embed></object>') == 'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1'), "Could not scrape URL from embed tag (1)" );
IWUTAssert( (scrapeURL('<object width="425" height="349"><param name="movie" value = \'  http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1  \'></param><param name="allowFullScreen" value="true"></param><embed src="http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1" type="application/x-shockwave-flash" allowfullscreen="true" width="425" height="349"></embed></object>') == 'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1'), "Could not scrape URL from embed tag (2)" );
IWUTAssert( (scrapeURL('<embed src="http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1&quote=\'" </embed>') == 'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1&quote=\''), "Could not scrape URL from embed tag (3)" );
IWUTAssert( (scrapeURL('<embed src=\'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1&quote="\' </embed>') == 'http://www.youtube.com/v/9kErrPOK94k&hl=en&color1=0x402061&color2=0x9461ca&border=1&quote="'), "Could not scrape URL from embed tag (4)" );


// GUID parsing
IWUTAssert( (scrapeGUID('') == null), "Empty GUID should return null" );
IWUTAssert( (scrapeGUID('foo') == null), "'foo' should return null GUID" );
IWUTAssert( (scrapeGUID('foo1') == 'foo1'), "'foo1' should return 'foo1' GUID" );
IWUTAssert( (scrapeGUID('-_9foo84') == '-_9foo84'), "'-_9foo84' should return '-_9foo84' GUID" );
IWUTAssert( (scrapeGUID('testGUID&') == null), "'testGUID&' should return null" );
IWUTAssert( (scrapeGUID('cnn.com/v/9kErr') == null), "'cnn.com/v/9kErr' should return null" );
IWUTAssert( (scrapeGUID('http://www.youtube.com/v/9kErr') == '9kErr'), "'http://www.youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('https://www.youtube.com/v/9kErr') == '9kErr'), "'https://www.youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('https://youtube.com/v/9kErr') == '9kErr'), "'https://youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('www.youtube.com/v/9kErr') == '9kErr'), "'www.youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('youtube.com/v/9kErr') == '9kErr'), "'youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('youtube.com/v/9kErr') == '9kErr'), "'youtube.com/v/9kErr' should return 9kErr" );
IWUTAssert( (scrapeGUID('youtube.com/v/9kErr&foo=bar#baz') == '9kErr'), "'youtube.com/v/9kErr&foo=bar#baz' should return 9kErr" );

IWUTAssert( (scrapeGUID('http://youtube.com/watch?v=s3F9sKv2Sd8&feature=dir') == 's3F9sKv2Sd8'), "'http://youtube.com/watch?v=s3F9sKv2Sd8&feature=dir' should return s3F9sKv2Sd8" );
