;+
;  CIRCLE_MASK, pixel_map, radius_in, pixres
;
;  PURPOSE: Make a circle-mask of zeros/ones 
;	    with given radius.
;	    
;  INPUTS:  pixel_map=2D array of zeros and ones, 
;	       where ones are the locations to be
;	       masked.
;	    radius_in=radius in arcsec
;	    pixres=size of pixels in arcsec
;
;  CREATED BY marco.viero@caltech.edu (2013-03-03)


FUNCTION CIRCLE_MASK, pixel_map, radius_in, pixres

radius=radius_in/pixres
xx=n_elements(pixel_map[*,0])
yy=n_elements(pixel_map[0,*])
beforex=alog2(xx)
beforey=alog2(yy)
if beforex ne beforey then begin
   if beforex gt beforey then $
      before = beforex $
      else $
      before = beforey
endif else before = beforey
l2 = ceil(before)
pad_side=2.^l2
outmap=dblarr(pad_side, pad_side)
outmap[0:xx-1,0:yy-1]=pixel_map
dist_array = shift(dist(pad_side,pad_side), pad_side/2., pad_side/2.)
circ=dblarr(pad_side, pad_side)
ind_one=where(dist_array le radius)
circ[ind_one]=1.
mask  = REAL_PART( FFT(FFT(circ, DOUBLE=double) * $
   FFT(outmap, DOUBLE=double), $
   /INV, DOUBLE=double) ) * pad_side * pad_side
mask=round(mask)
ind_holes=where(mask ge 1.0)
mask=mask*0d
mask[ind_holes]=1d
maskout=shift(mask, pad_side/2., pad_side/2.)

return, maskout[0:xx-1,0:yy-1]

end

