;+
;  GAUSS_KERN, fwhm, side, pixsize
;
;  PURPOSE: Create a 2D Gaussian (size=side x side)
;	    of given FWHM.
;
;  INPUTS:  FHWM = fwhm in arcsec
;	    side = number of pixels in size
;	    pixsize = size of pixels in arcsec
;
; CREATED BY marco.viero@caltech.edu (2013-03-03)
;-


FUNCTION GAUSS_KERN, fwhm, side, pixsize

;CREATE A 2D GAUSSIAN (SIDE^2) OF GIVEN FWHM
;PIXSIZE IN ARCSEC

k_dist = shift(dist(side)*pixsize, side/2, side/2)
sig = FWHM/2.355d
gauss = exp(-1d*(k_dist^2d/2d/sig^2.))

return, gauss   

end

