;+
;  SIMULTANEOUS_STACK_ARRAY, cube, p
;
;  PURPOSE: A function called by MPFITFUN, 
;	    which scales the convolved layers 
;	    (packed here into a cube) and sums 
;	    them together. 
;
; CREATED BY marco.viero@caltech.edu (2013-03-03)
;-

FUNCTION SIMULTANEOUS_STACK_ARRAY, cube, p

csize=size(cube,/dim)

cov=dblarr(csize[1])

for i=0, csize[0]-1 do $
	cov+=cube[i,*]*p[i]

return, cov
end
