;+
;PRO VIERO_QUICK_STACK,$
;   map_files, catalog_names, $
;   NOISE_MAP_NAMES=noise_files, $
;   STACKED_FLUXES=stacked_sed,STACKED_ERRORS=stacked_sed_err,$
;   EFWHM=efwhm, QUIET=quiet, N_SOURCES_MAX=n_sources_max
;
;INPUTS:
;*IF USING SPIRE* 
;  REQUIRES: 
;     - MAPS (one per wavelength) 
;     - CATALOGS (all to be stacked simultaneously, i.e., different masses, same z's)
;
;*IF USING OTHER MAPS* 
;  REQUIRES:
;     - MAPS (one per wavelength) 
;     - CATALOGS (all to be stacked simultaneously, i.e., different masses, same z's)
;     - EFWHM: Effective FWHM for each wavelength (GOOD FOR TESTING)
;
;OPTIONAL INPUTS:
;  - NOISE_MAP_NAMES: NOISEMAPS OPTIONAL 
;  - EFWHM: Effective FWHM for each wavelength (GOOD FOR TESTING)
;  - QUIET: Enable to keep mpfitfun from talking
;
;OUTPUTS:
;  - STACKED_FLUXES
;
;CALLS:
;  - STACK_IN_REDSHIFT_SLICES
;  - READFITS
;
;HISTORY:
;  CREATED BY marco.viero@caltech.edu (2013-03-03)
;-

PRO VIERO_QUICK_STACK, $
   map_names, catalog_names, $
   NOISE_MAP_NAMES=noise_map_names,$
   STACKED_FLUXES=stacked_sed,STACKED_ERRORS=stacked_sed_err,$
   EFWHM=efwhm, QUIET=quiet, N_SOURCES_MAX=n_sources_max 

IF NOT(KEYWORD_SET(quiet)) THEN quiet=0
IF NOT(KEYWORD_SET(n_sources_max)) THEN n_sources_max=50000l; Make it much bigger than typical list size

nmap=n_elements(map_names)

IF KEYWORD_SET(efwhm) THEN BEGIN
   IF n_elements(efwhm) eq 1 then efwhm=replicate(efwhm,nmap) 
ENDIF ELSE BEGIN
   fwhm =[18.1, 25.2, 36.6]
   efwhm=[17.6, 23.9, 35.2]; want to the measured effective FWHM later
ENDELSE

;PUT DATA INTO CUBE
nlists=n_elements(catalog_names)
nsources=0; initialize a counter
cube=dblarr(n_sources_max,nlists,2); nsources by nlists by 2 for RA/DEC
FOR i=0,nlists-1 DO BEGIN
   list_name=catalog_names[i]
   restore, list_name;, /verbose
   nsources_list=n_elements(ra)
   if nsources_list gt n_sources_max then begin
      print,'too many sources in catalog: use N_SOURCES_MAX flag'
      stop
   endif
   cube[0:nsources_list-1,i,0]=ra
   cube[0:nsources_list-1,i,1]=dec
   IF nsources_list gt nsources THEN nsources=nsources_list
ENDFOR
cube=cube[0:nsources-1,*,*]; Crop it down to the length of longest list

stacked_sed=dblarr(nmap,nlists) 
stacked_sed_err=dblarr(nmap,nlists) 
;STACK AT ONE WAVELENGTH AT A TIME 
FOR wv=0,nmap-1 DO BEGIN
   ;READ MAPS
   cmap=readfits(map_names[wv],hd,ext=1,/silent)
   IF KEYWORD_SET(noise_map_names) THEN $
      cnoise=readfits(noise_map_names[wv],nhd,ext=1,/silent) $
   ELSE cnoise=0

   stacked_flux=STACK_IN_REDSHIFT_SLICES($
      cmap,$
      hd,$
      cube,$
      efwhm[wv],$
      cnoise=cnoise,$
      err_ss=err_ss,$
      quiet=quiet)

   stacked_sed[wv,*]=stacked_flux
   stacked_sed_err[wv,*]=err_ss
ENDFOR
end


