;+
;  GETTING_STARTED_IDL_SCRIPT
;  
;  PURPOSE: An example of how to build a script to simultaneously stack 
;	    several correlated catalogs in one redshift bin.
;
;  DEFINE:
;     -map and catalog directories
;     -map names
;     -catalog lists:  
;	 -IDL save files with RA and Dec
;	 -NOTE: In general for best results, provide lists of _all_ masses at a _single_ redshift
;
;  USAGE: 
;     IDL> .r getting_started_idl_script 
;
;  CALLS:
;     VIERO_QUICK_STACK
;
;  HISTORY:
;     CREATED BY marco.viero@caltech.edu (2013-03-03)
;-

map_directory='test_data/'
catalog_directory=''
nlists=3.
list_names=catalog_directory+'test_cat_'+$
   strcompress(string(indgen(nlists),format='(i10)'),/remove_all)+'.sav'

map_suffix=['PSW','PMW','PLW']
wavelength=[250,350,500]
fwhm =[18.1, 25.2, 36.6]
efwhm=[17.6, 23.9, 35.2]; want to the measured effective FWHM later
quiet=1

map_files=map_directory+'uds_cutout_flux_'+map_suffix+'.fits'
noise_files=map_directory+'uds_cutout_noise_'+map_suffix+'.fits'

viero_quick_stack, $
   map_files, list_names, $
   NOISE_MAP_NAMES=noise_files, $
   STACKED_FLUXES=stacked_sed,STACKED_ERRORS=stacked_sed_err,$
   EFWHM=efwhm, $
   QUIET=quiet 

wv1=0 ; here wv1=0 means start at 250
wv2=2 ; and wv2=2 means end at 500
nwv=wv2-wv1+1
xt=textoidl('\lambda [\mum]')
yt='stacked flux [Jy]'
xr=[100,1000]
yr=[1e-3,3e-2]
plot,[0],[0],xr=xr,yr=yr,/xs,/ys,/xl,/yl,xtitle=xt,ytitle=yt,charsize=1.8
for j=0,nlists-1 do begin
   oplot, [wavelength[wv1:wv2]],[stacked_sed[*,j]],psym=-1.*j
   errplot, [wavelength[wv1:wv2]],[stacked_sed[*,j]-stacked_sed_err[*,j]],$
      [stacked_sed[*,j]+stacked_sed_err[*,j]]
endfor
end


